package token.tokenizer;

import token.*;
import java.io.*;
import java.util.*;


/**
 * Use the StreamTokenizer provided by in java.io to scan an input stream and extract an appropriate Token.
 */
public class XMLTokenizer extends ATokenizer {
  
  /**
   * Initialize _st to read from a input Reader file with the given input file name.
   *
   * @param inputFileName the name of the input text file
   * @throws FileNotFoundException
   */
  public XMLTokenizer(String inputFileName) throws FileNotFoundException {
    super(inputFileName);
    _st.ordinaryChar('/');
  }
  
  /**
   * Use _st to scan the input, extracts, and returns an appropriate concrete Token.
   *
   * @return next token
   * @throws IllegalArgumentException Thrown if an illegal input is encountered.
   */
  protected Token makeNextToken() {
    try {
      if (StreamTokenizer.TT_EOF != _st.nextToken()) {
        switch (_st.ttype) {
//          case '+':
//          {
//            System.err.println("Plus Token");
//            //STUDENT TO COMPLETE 
//            return tokFac.makeToken("+","+");
//          }
          case '<':
          {
            System.err.println("Found < Token");
            Token next = getNextToken();
            if(next.toString().equals("/") ){
              System.err.println("</ Token");
               //STUDENT TO COMPLETE 
              return tokFac.makeToken("\"</\"","</");

            }
            else {
              _st.pushBack();   // Ok only for this LL(2) situation. Need more robust pushback mechansim for LL(k)
              System.err.println("Left Bracket Token");
               //STUDENT TO COMPLETE 
              return tokFac.makeToken("\"<\"","<");
            }
          }
          case '>':
          {
            System.err.println("Right Bracket Token");
             //STUDENT TO COMPLETE 
            return tokFac.makeToken("\">\"",">");
          }
          case '/':
          {
            System.err.println("Forward Slash Token");
             //STUDENT TO COMPLETE 
            return tokFac.makeToken("\"/\"","/");
          }
          case StreamTokenizer.TT_NUMBER:
          {
            System.err.println("Num Token: "+_st.nval);
             //STUDENT TO COMPLETE 
            return tokFac.makeToken("Num","" + _st.nval);
          }
          case StreamTokenizer.TT_WORD:
          {
            System.err.println("Id Token: "+_st.sval);
             //STUDENT TO COMPLETE 
            return tokFac.makeToken("Id",_st.sval);
          }
          default:
            throw new IllegalArgumentException("XMLTokenizer: Illegal token type = "+_st.ttype);
        }
      }
      else {
        _fileReader.close();
        System.err.println("EOF Token");
         //STUDENT TO COMPLETE 
        return tokFac.makeToken("EOF","EOF");
        //throw new IllegalStateException("Reading past EOF!");
      }
    }
    catch (IOException e) {
      System.out.println(e.getMessage());
      return null;
    }
  }
  
}



  
  
